/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef INDEXLISTVIEWITEM_H
#define INDEXLISTVIEWITEM_H

#include "../../baselistviewitem.h"
#include "../../../dataaccess/tables/indicies/dbindex.h"
#include "../../../dataaccess/dbmastermanagerref.h"

/**
 * This list view item is used to represent a database table index.
 */
class IndexListViewItem: public BaseListViewItem, public DBIndex, public DBMasterManagerRef
{
				
public:
	
	/**
 	 * Constructor
   */		
	IndexListViewItem(QListViewItem *pqoListViewItem);
	
	/**
 	 * Constructor
   */			
	IndexListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem);	

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	virtual void showRightPressedMenu(const QPoint & rqoLocation, int nColumn);
	
	/**
 	 * Used to update the description.
   */			    	
	virtual void updateDescription();
	
};


#endif

