/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef TRIGGERITEMPOPUP_H
#define TRIGGERITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "triggerlistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a trigger item in the list viewer.
 */
class TriggerItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	TriggerListViewItem * m_poTriggerListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	TriggerItemPopup(QWidget *pqoParent, TriggerListViewItem *poTriggerListViewItem);

	/**
	 * Used to get a reference to the Trigger item that this popup was generated from.
	 */
	TriggerListViewItem * getTriggerListViewItem() const;
	
protected slots:	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void editComment();
	
private:

};


#endif

